package gov.va.genisis2.dao.impl;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.genisis2.dao.IRoleTypeDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.RoleType;

/**
 *
 * The RoleType data access object (DAO) is an object that provides an abstract
 * interface to some type of database or other persistence mechanism. By mapping
 * application calls to the persistence layer, RoleType DAO provide some
 * specific data operations without exposing details of the database.
 * 
 * @author Prasad Thummalapalli
 *
 */
@Repository
@Transactional(value = "transactionManager")
public class RoleTypeDao extends AbstactHibernateDao implements IRoleTypeDao {

	private static final Logger LOGGER = LoggerFactory.getLogger(RoleTypeDao.class);

	@Autowired
	private SessionFactory sessionFactory;

	@Override
	@Cacheable(value = "getRoleType", key = "#id")
	public RoleType getRoleType(int id) throws GenisisDAOException {
		RoleType roleType = null;
		try {
			Session session = sessionFactory.getCurrentSession();
			roleType = session.get(RoleType.class, id);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred while querying getRoleType.", ex);
			throw new GenisisDAOException("Exception occurred while querying getRoleType.", ex);
		}
		return roleType;
	}

}
